/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./components/**/*.{js,ts,jsx,tsx,mdx}",
    "./app/**/*.{js,ts,jsx,tsx,mdx}",
    "./templates/**/*.{js,ts,jsx,tsx,mdx}",
  ],
  mode: 'jit',
  theme: {
    extend: {
      colors: {
        black: '#000000',
        'oxford-blue': '#14213d',
        'orange-web': '#fca311',
        platinum: '#e5e5e5',
        white: '#ffffff',
      },
     
    },
  },
  safelist: [
    'bg-yellow-400',
    'bg-blue-400',
    'bg-green-400',
    'bg-red-400',
    'bg-green-100',
    'bg-red-100',
    'border-green-400',
    'border-red-400',
    'text-green-700',
    'text-red-700',
  
  ],
  aspectRatio: {
    '1/1': '1 / 1',
  },
  plugins: [],
};
